/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.core.Debugger;
import jace.core.Device;

public abstract class CPU
extends Device {
    private Debugger debugger = null;
    private boolean halt = false;
    @ConfigurableField(name="Enable trace")
    public boolean trace = false;
    @ConfigurableField(name="Program Counter")
    public int programCounter = 0;

    public boolean isHalt() {
        return this.halt;
    }

    public void setHalt(boolean h) {
        this.halt = h;
    }

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public void setTraceEnabled(boolean t) {
        this.trace = t;
    }

    public void setDebug(Debugger d) {
        this.debugger = d;
        this.halt = true;
    }

    public void clearDebug() {
        this.debugger = null;
        this.halt = false;
    }

    public int getProgramCounter() {
        return this.programCounter;
    }

    public void setProgramCounter(int programCounter) {
        this.programCounter = 0xFFFF & programCounter;
    }

    public void setProgramCounter(int programCounter, boolean isJSR) {
        if (isJSR) {
            this.pushPC();
        }
        this.setProgramCounter(programCounter);
    }

    public void incrementProgramCounter(int amount) {
        this.programCounter += amount;
        this.programCounter = 0xFFFF & this.programCounter;
    }

    public void tick() {
        if (this.halt) {
            return;
        }
        this.executeOpcode();
        if (this.debugger != null) {
            if (!this.debugger.isActive() && this.debugger.hasBreakpoints()) {
                for (int i : this.debugger.getBreakpoints()) {
                    if (i != this.getProgramCounter()) continue;
                    this.debugger.setActive(true);
                }
            }
            if (this.debugger.isActive()) {
                this.halt = true;
                this.debugger.updateStatus();
            }
        }
    }

    protected abstract void executeOpcode();

    public abstract void reset();

    public abstract void generateInterrupt();

    public void suspend() {
        this.setHalt(true);
    }

    public void resume() {
        this.setHalt(false);
    }

    public abstract void pushPC();

    public void attach() {
    }

    public void detach() {
    }
}

